# Bank-API-Integration & GoBD-Compliance - Dokumentation

## 🏦 Bank-API-Integration

### Übersicht

Das Kassenbuch unterstützt jetzt die Integration mit verschiedenen Bank-APIs über FinTech-API-Anbieter. Dies ermöglicht die automatische Synchronisation von Bank-Transaktionen und die Einhaltung der GoBD-Richtlinien.

### Unterstützte API-Provider

#### 1. **NDGIT (FinTech-API)**
- **URL:** https://qwist.com/de/produkte/ndgit/
- **Beschreibung:** Professioneller FinTech-API-Anbieter für Bank-Integration
- **Features:**
  - Einheitliche API für alle deutschen Banken
  - PSD2-konforme Implementierung
  - Automatische Kategorisierung von Transaktionen
  - Sichere OAuth2-Authentifizierung

#### 2. **FinAPI**
- **Beschreibung:** Etablierter API-Provider für Bank-Integration
- **Features:**
  - Direkte Bank-Anbindung
  - Umfangreiche Dokumentation
  - Sandbox-Umgebung für Tests

#### 3. **Berlin Group**
- **Beschreibung:** Standardisierte API nach Berlin Group Standard
- **Features:**
  - PSD2-konforme Implementierung
  - Offener Standard
  - EU-weite Kompatibilität

#### 4. **Custom API**
- **Beschreibung:** Eigene API-Implementierung
- **Features:**
  - Flexibel konfigurierbar
  - Individuelle Anpassungen möglich

### Konfiguration

#### API-Einstellungen
1. **API Provider:** Wählen Sie Ihren bevorzugten API-Anbieter
2. **Umgebung:** Sandbox (Test) oder Production (Live)
3. **API Key:** Ihr persönlicher API-Schlüssel
4. **API Secret:** Ihr API-Geheimnis für die Authentifizierung
5. **Base URL:** Die Basis-URL der API
6. **Sync Intervall:** Automatische Synchronisation in Minuten (5-1440)

#### Verbindungsprozess
1. Klicken Sie auf den **"Bank API"** Button
2. Füllen Sie die API-Konfiguration aus
3. Klicken Sie auf **"Verbinden"**
4. Nach erfolgreicher Verbindung können Sie **"Synchronisieren"** klicken

### Automatische Transaktion-Import

#### Importierte Daten
- **Transaktions-ID:** Eindeutige Bank-Transaktions-ID
- **Datum:** Transaktionsdatum
- **Betrag:** Transaktionsbetrag in EUR
- **Beschreibung:** Transaktionsbeschreibung
- **Gegenpartei:** Name, IBAN, BIC
- **Kategorie:** Automatische Kategorisierung
- **Status:** Pending, Completed, Failed

#### Auto-Import Features
- **Automatische Kategorisierung:** Transaktionen werden automatisch kategorisiert
- **Duplikatserkennung:** Verhindert doppelte Einträge
- **GoBD-Compliance:** Alle importierten Einträge sind GoBD-konform
- **Audit-Trail:** Vollständige Protokollierung aller Imports

### Sicherheit

#### Datenschutz
- **Verschlüsselung:** Alle API-Kommunikation ist verschlüsselt
- **Lokale Speicherung:** API-Credentials werden lokal gespeichert
- **Keine Cloud-Synchronisation:** Maximale Datenschutz
- **Session-Management:** Sichere Session-Verwaltung

#### Authentifizierung
- **OAuth2:** Standardisierte Authentifizierung
- **API Key/Secret:** Sichere Credential-Verwaltung
- **Token-Management:** Automatische Token-Erneuerung

---

## 🛡️ GoBD-Compliance

### Übersicht

Die GoBD (Grundsätze zur ordnungsmäßigen Führung und Aufbewahrung von Büchern, Aufzeichnungen und Unterlagen in elektronischer Form) sind gesetzliche Anforderungen für die digitale Buchhaltung.

### Implementierte GoBD-Features

#### 1. **Audit-Trail**
- **Vollständige Protokollierung:** Alle Änderungen werden protokolliert
- **Wer hat was wann geändert:** Detaillierte Benutzer-Aktivitäten
- **Vorher-Nachher-Werte:** Vergleich der Änderungen
- **IP-Adressen:** Protokollierung der Zugriffsquellen

#### 2. **Datenverschlüsselung**
- **AES-256:** Industriestandard-Verschlüsselung
- **Ende-zu-Ende:** Vollständige Verschlüsselung
- **Schlüssel-Management:** Sichere Schlüssel-Verwaltung
- **Verschlüsselungslevel:** Basic, Advanced, Enterprise

#### 3. **Zugriffsprotokollierung**
- **Benutzer-Aktivitäten:** Alle Zugriffe werden protokolliert
- **Session-Management:** Sichere Session-Verwaltung
- **IP-Tracking:** Protokollierung der Zugriffsquellen
- **User-Agent:** Browser- und System-Informationen

#### 4. **Datenaufbewahrung**
- **10 Jahre:** Gesetzliche Aufbewahrungsfrist
- **Automatische Archivierung:** Automatische Archivierung alter Daten
- **Löschschutz:** Verhindert versehentliches Löschen
- **Backup-Strategie:** Regelmäßige Datensicherung

#### 5. **Monatsabschlüsse**
- **Sperrung:** Einträge können nach Abschluss nicht mehr geändert werden
- **Export-Pflicht:** Automatische Export-Generierung
- **Audit-Log:** Vollständige Protokollierung der Abschlüsse
- **GoBD-Konformität:** Einhaltung der gesetzlichen Vorgaben

### Compliance-Status

#### Status-Typen
- **Compliant:** Alle Anforderungen erfüllt
- **Non-Compliant:** Anforderungen nicht erfüllt
- **Pending Review:** Prüfung läuft

#### Compliance-Prüfung
Die automatische Compliance-Prüfung überprüft:
- ✅ Audit-Trail aktiviert
- ✅ Datenverschlüsselung aktiviert
- ✅ Zugriffsprotokollierung aktiviert
- ✅ Änderungsprotokollierung aktiviert
- ✅ Backup aktiviert
- ✅ Datenaufbewahrung konfiguriert (≥10 Jahre)

### Export-Funktionen

#### GoBD-konforme Exporte
1. **CSV Export:** Standard-Format für Excel
2. **Excel (XLSX):** Direkte Excel-Dateien
3. **PDF Export:** Druckbare Berichte
4. **XML Export:** GoBD-konformes XML-Format
5. **DATEV Export:** DATEV-konform für Buchhaltungssoftware
6. **Audit-Log Export:** Vollständiges Audit-Protokoll

#### Export-Features
- **Zeitstempel:** Automatische Zeitstempel
- **Prüfsummen:** Integritätsprüfung
- **Verschlüsselung:** Verschlüsselte Exporte
- **Signierung:** Digitale Signierung möglich

---

## 🔧 Technische Implementierung

### Datenstrukturen

#### BankTransaction Interface
```typescript
interface BankTransaction {
  id: string;
  transactionId: string;
  bankAccountId: string;
  date: string;
  valueDate: string;
  amount: number;
  currency: string;
  description: string;
  purpose: string;
  counterpartyName: string;
  counterpartyIBAN: string;
  counterpartyBIC: string;
  transactionType: 'credit' | 'debit';
  category: string;
  status: 'pending' | 'completed' | 'failed';
  reference: string;
  endToEndReference: string;
  mandateReference: string;
  creditorId: string;
  remittanceInformation: string;
  createdAt: string;
  updatedAt: string;
}
```

#### GoBDCompliance Interface
```typescript
interface GoBDCompliance {
  version: string;
  lastAudit: string;
  auditTrailEnabled: boolean;
  dataRetentionYears: number;
  backupEnabled: boolean;
  backupFrequency: string;
  encryptionEnabled: boolean;
  accessLogging: boolean;
  changeLogging: boolean;
  exportFormats: string[];
  complianceStatus: 'compliant' | 'non_compliant' | 'pending_review';
  complianceNotes: string[];
}
```

### Funktionen

#### Bank-API-Funktionen
- `connectBankAPI()`: Verbindung zur Bank-API herstellen
- `syncBankTransactions()`: Bank-Transaktionen synchronisieren
- `autoImportTransactions()`: Automatischer Import von Transaktionen

#### GoBD-Funktionen
- `updateGoBDCompliance()`: Compliance-Einstellungen aktualisieren
- `addGoBDAuditLog()`: GoBD-Audit-Log hinzufügen
- `runGoBDComplianceCheck()`: Compliance-Prüfung durchführen

---

## 📋 Verwendung

### Erste Schritte

#### 1. Bank-API einrichten
1. Klicken Sie auf **"Bank API"** Button
2. Wählen Sie Ihren API-Provider (z.B. NDGIT)
3. Füllen Sie die API-Credentials aus
4. Klicken Sie auf **"Verbinden"**

#### 2. GoBD-Compliance konfigurieren
1. Klicken Sie auf **"GoBD"** Button
2. Überprüfen Sie die Compliance-Einstellungen
3. Aktivieren Sie alle erforderlichen Features
4. Klicken Sie auf **"Compliance prüfen"**

#### 3. Transaktionen synchronisieren
1. Nach erfolgreicher API-Verbindung
2. Klicken Sie auf **"Synchronisieren"**
3. Transaktionen werden automatisch importiert
4. Überprüfen Sie die importierten Einträge

### Best Practices

#### Sicherheit
- Verwenden Sie starke API-Credentials
- Aktivieren Sie alle GoBD-Compliance-Features
- Führen Sie regelmäßige Compliance-Prüfungen durch
- Erstellen Sie regelmäßige Backups

#### Datenqualität
- Überprüfen Sie importierte Transaktionen
- Kategorisieren Sie Transaktionen korrekt
- Dokumentieren Sie alle Änderungen
- Führen Sie regelmäßige Monatsabschlüsse durch

#### Wartung
- Überprüfen Sie regelmäßig die API-Verbindung
- Aktualisieren Sie Compliance-Einstellungen
- Exportieren Sie regelmäßig Audit-Logs
- Überwachen Sie die Compliance-Status

---

## ⚠️ Wichtige Hinweise

### Rechtliche Anforderungen
- **GoBD-Compliance:** Einhaltung der gesetzlichen Vorgaben ist Pflicht
- **Datenaufbewahrung:** 10 Jahre Aufbewahrungsfrist
- **Audit-Trail:** Vollständige Protokollierung erforderlich
- **Backup:** Regelmäßige Datensicherung notwendig

### Datenschutz
- **DSGVO:** Einhaltung der Datenschutz-Grundverordnung
- **Lokale Speicherung:** Daten bleiben auf Ihrem System
- **Verschlüsselung:** Alle sensiblen Daten sind verschlüsselt
- **Zugriffskontrolle:** Nur autorisierte Benutzer haben Zugriff

### Support
Bei Fragen oder Problemen:
1. Überprüfen Sie die API-Credentials
2. Kontaktieren Sie Ihren API-Provider
3. Führen Sie eine Compliance-Prüfung durch
4. Erstellen Sie ein Backup vor Änderungen

---

**Das Kassenbuch ist jetzt vollständig GoBD-konform und unterstützt professionelle Bank-API-Integration!** 🎉 